﻿using System;
using System.Collections.Generic;
using System.Web.Script.Serialization;
using System.ComponentModel;
using System.Collections.ObjectModel;
using System.Runtime.Serialization.Json;
using System.IO;
using System.Text;

namespace AnimatedImageRotator
{
    public class ImageListConverter : TypeConverter
    {
        public override object ConvertTo(ITypeDescriptorContext context, 
                    System.Globalization.CultureInfo culture, object value, 
                    Type destinationType)
        {
            Collection<ImageUrl> imageList = value as Collection<ImageUrl>;

            if (imageList != null && destinationType == typeof(string))
            {
                StringBuilder builder = new StringBuilder();
                builder.Append("[");
                bool first = true;
                foreach (ImageUrl imageUrl in imageList)
                {
                    if (first)
                    {
                        first = false;
                    }
                    else
                    {
                        builder.Append(",");
                    }

                    builder.Append("\"");
                    builder.Append(imageUrl.Url.Replace("~/", ""));
                    builder.Append("\"");
                }
                builder.Append("]");

                return builder.ToString();
            }

            //if (imageList != null && destinationType == typeof(string))
            //{
            //    string[] stringList = new string[imageList.Count];
            //    int i = 0;
            //    foreach (ImageUrl imageUrl in imageList)
            //    {
            //        stringList[i] = imageUrl.Url.Replace("~/", "");
            //        i++;
            //    }

            //    DataContractJsonSerializer javaScriptSerializer =
            //        new DataContractJsonSerializer(typeof(string[]));
            //    MemoryStream memoryStream = new MemoryStream();
            //    javaScriptSerializer.WriteObject(memoryStream, stringList);

            //    return Encoding.Default.GetString(memoryStream.ToArray());

            //}

            return base.ConvertTo(context, culture, value, destinationType);
        }
    }
}
